/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;

final class BaselineHelper {
    private static final Set<Class<? extends JComponent>> _centerAlignedComponents = new HashSet<Class<? extends JComponent>>();

    private BaselineHelper() {
    }

    public static int getBaseline(Component comp) {
        Dimension size2 = comp.getPreferredSize();
        int baseline = BaselineHelper.getBaseline(comp, size2.width, size2.height);
        if (baseline < 0) {
            boolean isCenter = false;
            for (Class<? extends JComponent> clazz2 : _centerAlignedComponents) {
                if (!clazz2.isInstance(comp)) continue;
                isCenter = true;
                break;
            }
            if (!isCenter) {
                baseline = 0;
            }
        }
        return baseline;
    }

    private static int getBaseline(Component comp, int width, int height) {
        return comp.getBaseline(width, height);
    }

    static {
        _centerAlignedComponents.add(JSeparator.class);
        _centerAlignedComponents.add(JProgressBar.class);
    }
}

